#pragma once
#include "IGameState.h"
#include "IListener.h"
#include "CEvent.h"
#include "CSGD_ObjectFactory.h"
#include "CBase.h"
#include <string>
#include <vector>
#include "CNote.h"
#include "CBitmapFontManager.h"
#include "CBitmapFont.h"

class CSGD_ObjectManager;
class CSGD_MessageSystem;
class CBaseMessage;
class CPlayer;
class CBeatAnalyzer;
class CBase;
class CNoteManager;

using std::string;



class CGamePlayState : public IGameState, public IListener
{
	int m_nSoundID;
	int m_nHudID;
	int m_nStaffID;
	int m_nVertStaffID;
	int m_nStatusContainerID;
	int m_nStatusBarID;
	float m_fBarStart;
	float m_fBarEnd;
	float m_fBarPosition;
	int m_nEqIndex;
	float m_fTimer;

	float m_fProgress;
	RECT m_rProgressRect;

	//The object management systems
	CSGD_ObjectFactory<string, CBase>*		m_pOF;
	CSGD_ObjectManager*		m_pOM;
	CSGD_MessageSystem*		m_pMS;

	//The player
	CPlayer* m_pPlayer;
	CNoteManager* m_pNM;
	CBitmapFontManager*		m_pBM;
	CBitmapFont				m_pFont;

public:
	static CGamePlayState* GetInstance(void)
	{
		static CGamePlayState m_Instance;
		return &m_Instance;
	}

	///////////////////////////////////////////////////////
	//	Function : MessageProc
	//	Last Modified: July 23, 2008	
	//	Purpose: This will handle messages
	///////////////////////////////////////////////////////
	static friend void MessageProc(CBaseMessage* pMsg);

	void Enter(void);

	bool Input(float fElapsedTime);
	void Update(float fElapsedTime);
	void Render(void);
	
	void Exit(void);

	void HandleEvent(CEvent* pEvent);
};
